% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_partitions.R
\name{get_partitions}
\alias{get_partitions}
\title{Gather a collection of community detection partitions (\code{get_partitions})}
\usage{
get_partitions(
  network,
  gamma_range = c(0, 3),
  n_runs = 100,
  n_iterations = 2,
  seed = NULL,
  add_comm_detect = TRUE
)
}
\arguments{
\item{network}{The network, as igraph object, to be clustered into communities. Only undirected networks are currently supported. If the object has a 'weight' edge attribute, then that attribute will be used.}

\item{gamma_range}{The range of the resolution parameter gamma (default from 0 to 4).}

\item{n_runs}{The number of \code{cluster_leiden} runs to be attempted (default = 100).}

\item{n_iterations}{Parameter to be passed to cluster_leiden (default = 2).}

\item{seed}{Optional random seed for reproducing pseudo-random results.}

\item{add_comm_detect}{Boolean to decide whether to also call the clustering algorithms included in \code{comm_detect} (default = T). Alternatively, the output of \code{comm_detect} can be provided directly here.}
}
\value{
\code{get_partitions} returns a list of unique partitions appropriate for subsequent input to \code{CHAMP}.
}
\description{
The \code{get_partitions} function is a wrapper to gather a collection of community detection partitions using igraph's \code{cluster_leiden} for maximizing modularity at various resolution parameter values, along with the routines called by the \code{comm_detect} function, to gather different partitions for subsequent input to the \code{CHAMP} code for post-processing partitions to identify domains of modularity optimization.
}
\examples{
# Use get_partitions to generate multiple partitions of the
# Zachary karate club at different resolution parameters
data(karate, package = "igraphdata")
partitions <- get_partitions(karate, n_runs = 2500)
}
\author{
Peter J. Mucha (\email{peter.j.mucha@dartmouth.edu}), Alex Craig, Rachel Matthew, Sydney Rosenbaum and Ava Scharfstein
}
