% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/application.R
\docType{methods}
\name{vicinity}
\alias{vicinity}
\alias{vicinity,trigrid,character-method}
\title{The neighbouring faces of faces in an icosahedral grid}
\usage{
vicinity(gridObj, faces, ...)

\S4method{vicinity}{trigrid,character}(gridObj, faces, order = 1,
  output = "vector", self = TRUE, ...)
}
\arguments{
\item{gridObj}{A \code{trigrid} or \code{hexagrid} class object.}

\item{faces}{A character vector specifying names of faces.}

\item{...}{arguments passed to the igraph::ego() function}

\item{order}{Passed to the igraph::ego() function, an integer value specifying the size of the neighborhood around a face.}

\item{output}{Characater value, the type of the output. The default \code{"vector"} 
will give back the names of the faces that adjacent to the faces specified, 
including themselves. \code{"list"} will return a list.}

\item{self}{logical value indicating whether the input faces should be in the output. For the \code{"list"} output option, the input face names will be
omitted only from those character vectors that contain face names that are related to the face in question.}
}
\value{
A character vector or a list of character vectors.
}
\description{
This function will return neighbouring faces of the input faces.
}
\examples{
	g <- trigrid(3)
	ne <- vicinity(g, c("F4", "F10"))
	ne

}

