% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{CarToPol}
\alias{CarToPol}
\title{Conversion of 3d Cartesian coordinates to polar coordinates}
\usage{
CarToPol(matXYZ, norad = FALSE, origin = c(0, 0, 0))
}
\arguments{
\item{matXYZ}{3-column numeric matrix containing xyz coordinates in a Cartesian space}

\item{norad}{Logical value, toggles whether the rho coordinate (distance from origin) should be omitted or not.}

\item{origin}{Numeric vector of length 3, defining the center of the sphere. Defaults to c(0,0,0).}
}
\value{
A 3-column or 2-column numeric matrix with longitude, latitude and, if set accordingly, radius data.
}
\description{
The function uses basic trigonometric relationships to transform xyz coordinates to polar coordinates
}
\examples{
# some random points
xyz <- rbind(
	 c(6371, 0,0),
	 c(0, 6371,0),
	 c(1000,1000,1000)
)

# conversions
  CarToPol(xyz)
}

