% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.r
\docType{methods}
\name{plot3d,trigrid-method}
\alias{plot3d,}
\alias{plot3d,hexagrid-method}
\alias{plot3d,trigrid-method}
\alias{plot3d-hexagrid-method}
\alias{plot3d-trigrid-method}
\title{3d plotting of an icosahedral grid or its subset}
\usage{
\S4method{plot3d}{trigrid}(x, type = c("l"), sphere = NULL, add = FALSE,
  guides = TRUE, ...)

\S4method{plot3d}{hexagrid}(x, type = c("l"), sphere = NULL,
  color = "gray70", add = FALSE, guides = TRUE, ...)
}
\arguments{
\item{x}{The \code{trigrid}, \code{hexagrid} or \code{facelayer} object to be plotted.}

\item{type}{A character value specifying the part of the grid to be plotted by the call of the function. 
\code{"v"} plots the grid vertex points. 
\code{"e"} draws the grid edges.
\code{"f"} draws the grid faces.
\code{"c"} draws the face centers of the grid.}

\item{sphere}{Defaults to NULL, adding a central white sphere to the plot. Assigning a numeric value will draw a new sphere with the given radius,
\code{FALSE} does not plot the sphere.}

\item{add}{Logical value indicating whether a new plot shall be drawn, or the currently plotted information should be added to the active rgl device.}

\item{guides}{Logical value indicating whether the guidelines of the polar coordinate system shall be plotted.}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}).}

\item{color}{Only for the hexagrid plotting: character value/values, passed to the faces3d() function instead of col.}
}
\value{
The function does not return any value.
}
\description{
This is a generic function used to plot either a \code{trigrid} or a \code{hexagrid} object or their \code{facelayer} in 3d space.

3d plotting of an icosahedral grid or its subset
}
\details{
The function is built on the openGL renderer of the R package \code{rgl}.
}
\examples{
# create a hexagonal grid
    g <- hexagrid(c(2,2))
# plot the grid in 3d space
    plot3d(g, col="blue")
# make a subset to select faces
   subG <- subset(g, c("F5", "F2"))
# plot the subset defined above
    plot3d(subG, type="f", col=c("orange"), add=TRUE, lwd=1)
}

