% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{breast_cancer}
\alias{breast_cancer}
\title{Wisconsin Breast Cancer Database}
\format{
a tibble with 699 rows and 11 variables. All numerical values are
integers in the range 1 to 10.
\describe{
\item{id}{sample code number}
\item{clump_thick}{clump thickness}
\item{unif_cell_size}{uniformity of cell size}
\item{unif_cell_shape}{uniformity of cell shape}
\item{marg_adh}{marginal adhesion}
\item{ep_cell_size}{single epithelial cell size}
\item{bare_nucl}{bare nuclei}
\item{bland_chromat}{bland chromatin}
\item{norm_nucl}{normal nucleoli}
\item{mitoses}{mitoses}
\item{class}{"benign" (458) or "malignant" (241)}
}
}
\source{
The data is available on the
\href{https://archive.ics.uci.edu/dataset/15/breast+cancer+wisconsin+originall}{UC Irvine Machine Learning Repository}.

O. L. Mangasarian and W. H. Wolberg, \emph{Cancer diagnosis via linear programming},
SIAM News, Volume 23(5) (1990) 1 & 18.
}
\usage{
breast_cancer
}
\description{
Breast cancer database obtained from the University of Wisconsin
Hospitals, Madison from Dr. William H. Wolberg. The data were collected
in 8 from 1989 to 1991 and are sorted in chronological order.
}
\keyword{datasets}
