% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{predict.survival_learner}
\alias{predict.survival_learner}
\title{Return the predictions made by a survival learner for each point in the
features}
\usage{
\method{predict}{survival_learner}(obj, X, t = NULL, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{t}{The time for which to predict survival probability, defaulting to
returning the entire survival curve if not supplied}

\item{...}{Additional arguments (unused)}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/IAIBase/reference/#IAI.predict-Tuple\%7BLearner\%7BIAIBase.SurvivalTask\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict}}
}
\examples{
\dontrun{iai::predict(lnr, X, t = 10)}

}
