% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{Poly}
\alias{Poly}
\title{Polynomial Matrix}
\usage{
Poly(x, degree = 1, coefs = NULL, raw = FALSE, ...)
}
\arguments{
\item{x}{variable to convert to matrix}

\item{degree}{degree of polynomial}

\item{coefs}{pass to poly() function}

\item{raw}{pass to poly() function}

\item{...}{more arguments for the poly() function}
}
\value{
a matrix, with NAs in the missing rows
}
\description{
A modified `poly()` function that allows for missing values.
}
\details{
Credit goes to whoever posted this online first (google search if you must find it!)
}
\examples{
Poly(rnorm(100), degree = 2L)

# handles missing values:
iris.na <- iris
iris.na$Sepal.Length[c(5, 10)] <- NA
lm(Sepal.Width ~ Poly(Sepal.Length, 2L), data = iris.na)

\dontrun{# stats::poly() produces an error in this case:
lm(Sepal.Width ~ poly(Sepal.Length, 2L), data = iris.na)
}
}
\author{
Tom Elliott
}
