% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_pairingits.R
\name{pairingits}
\alias{pairingits}
\title{Pairing two irregularly observed time series}
\usage{
pairingits(x, ...)
}
\arguments{
\item{x}{An object of class `utilities`.}

\item{...}{Additional arguments for pairing time series: 
\describe{
  \item{lc1}{A data frame with three columns corresponding to the first irregularly observed time series.}
  \item{lc2}{A data frame with three columns corresponding to the second irregularly observed time series.}
  \item{tol}{A numeric value indicating the tolerance parameter.}
}}
}
\value{
An object of class `utilities` with two slots:
\item{series}{A matrix containing the paired time series, where unmatched measurements are filled with `NA`.}
\item{series_esd}{A matrix containing the paired error standard deviations of the time series, where unmatched measurements are filled with `NA`.}
\item{times}{A numeric vector with the paired observational times.}
}
\description{
This method pairs the observational times of two irregularly observed time series.
}
\details{
The method checks the observational times in both input time series and pairs the measurements if they fall within the specified tolerance (`tol`). If a measurement in one series cannot be paired, it is filled with `NA` values for the corresponding columns of the other series.
}
\examples{
data(cvnovag)
data(cvnovar)
datag=cvnovag
datar=cvnovar
o1=iAR::utilities()
o1<-pairingits(o1, datag,datar,tol=0.1)
pargr1=na.omit(o1@paired)
st=apply(pargr1[,c(1,4)],1,mean)
model_BiAR <- BiAR(times = st,series=pargr1[,c(2,5)],series_esd=pargr1[,c(3,6)])
model_BiAR <- kalman(model_BiAR)

}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
