% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonicfit.R
\name{harmonicfit}
\alias{harmonicfit}
\title{Harmonic Fit to Time Series}
\usage{
harmonicfit(
  file,
  f1,
  nham = 4,
  weights = NULL,
  print = FALSE,
  remove_trend = TRUE
)
}
\arguments{
\item{file}{A matrix with two columns. The first column corresponds to the observations times, and the second column corresponds to the measures.}

\item{f1}{Frequency (1/Period) of the time series}

\item{nham}{Number of harmonic components in the model}

\item{weights}{An array with the weights of each observation}

\item{print}{logical; if true, the summary of the harmonic fitted model will be printed. The default value is false.}

\item{remove_trend}{logical; if true, the linear trend of time series will be removed before the the harmonic model is fitted.}
}
\value{
A list with the following components:
\item{res}{ Residuals to the harmonic fit of the time series.}
\item{t}{ Observations times.}
\item{R2}{ Adjusted R-Squared.}
\item{MSE}{ Mean Squared Error.}
\item{coef}{ Summary of the coefficients estimated by the harmonic model.}
}
\description{
This function fit an k-harmonic function to time series data.
}
\examples{
data(clcep)
f1=0.060033386
#results=harmonicfit(file=clcep[,1:2],f1=f1)
#results$R2
#results$MSE
#results=harmonicfit(file=clcep[,1:2],f1=f1,nham=3)
#results$R2
#results$MSE
#results=harmonicfit(file=clcep[,1:2],f1=f1,weights=clcep[,3])
#results$R2
#results$MSE
}
