% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clint.R
\name{get_clint}
\alias{get_clint}
\title{Retrieve and parse intrinsic hepatic clearance}
\usage{
get_clint(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  force.human.clint = FALSE,
  suppress.messages = FALSE,
  clint.pvalue.threshold = 0.05
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  if
parameters is not specified then the chemical must be identified by either
CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
 -- if parameters is not specified then the chemical must be identified by 
either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing hepatic clearance with
human values if true.}

\item{force.human.clint}{If a non-human species value (matching argument
species) is available, it is ignored and the human intrinsic clearance is 
used}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}
}
\value{
list containing:
\item{CLint.point}{Point estimate (central tendency) of the intrinsic hepatic clearance}
\item{Clint.dist}{Quantiles of a distribution (median, lower, upper 95th percentiles) and pvalue}
\item{Clint.pvalue}{pvalue for whether disapperance of parent compound was observed}
}
\description{
This function retrieves the chemical- and species-specific intinsic
hepatic clearance (\ifelse{html}{\out{Cl<sub>int</sub>}}{\eqn{Cl_{int}}},
inits of uL/min/million hepatocytes)  
from \code{\link{chem.physical_and_invitro.data}}. 
If that parameter is described by a distribution (that is, a median, 
lower-, upper-95th percentile and p-value separated by commas) this 
function splits those quantiles into separate values. Most 
\ifelse{html}{\out{Cl<sub>int</sub>}}{\eqn{Cl_{int}}} values have an
accompanying p-value indicating the probability that no decrease was 
observed. If the p-values exceeds a threhsold (default 0.05) the clearance is
set to zero (no clearance). Some values extracted from the literature do not
have a p-value.
}
\seealso{
\code{\link{chem.physical_and_invitro.data}}
}
\author{
John Wambaugh
}
\keyword{Parameter}
\keyword{in-vitro}
