context("get_type")
library(testthat)
library(hmi)

#test_check("hmi")

test_that("get_type works for different inputs", {
  expect_equal(get_type(rnorm(10)), "cont")
  expect_equal(get_type(1:10), "count")
  expect_equal(get_type(1:30), "cont")
  expect_equal(get_type(rep(1, 10)), "intercept")
  expect_equal(get_type(rep(2, 10)), "intercept")
  expect_equal(get_type(rep("a", 10)), "intercept")
  expect_equal(get_type(rep("a", 10), NA), "intercept")
  expect_equal(get_type(c(0, 1, 0, 1)), "binary")
  expect_equal(get_type(c(2, 1, 2, 1)), "binary")
  expect_equal(get_type(c(2, 1, 2, 1, NA)), "binary")
  expect_equal(get_type(c("a", "b", "a", "b")), "binary")
  expect_equal(get_type(c("a", "b", "a", "b", NA)), "binary")
  expect_equal(get_type(c("a", "b", "a", "c")), "categorical")
  expect_equal(get_type(c("a", "b", "a", "c", NA)), "categorical")
  expect_equal(get_type(factor(c("a", "b", "a", "c"))), "categorical")
  expect_equal(get_type(factor(c("a", "b", "a", "c"), ordered = TRUE)), "ordered_categorical")
  expect_equal(get_type(rep(c(100, 500, 1000), each = 20)), "roundedcont")
  expect_equal(get_type(c(rnorm(80), rep(0, 20))), "semicont")
  expect_equal(get_type(as.interval(c("100;200", "80;120", "100;100"))), "roundedcont")
  expect_equal(get_type(as.interval(c("89;91", "80;120", "101;101"))), "interval")
})
