% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{combine_hermite}
\alias{combine_hermite}
\title{Combines a list of Hermite estimators}
\usage{
combine_hermite(hermite_estimators)
}
\arguments{
\item{hermite_estimators}{A list of hermite_estimator objects.}
}
\value{
An object of class hermite_estimator.
}
\description{
This method allows a list of Hermite based estimators of class
hermite_estimator to be consistently combined.
}
\details{
Note that the N and standardize arguments must be the same for all estimators
in order to combine them. In addition, note that exponentially weighted
estimators cannot be combined. If the Hermite estimators are not
standardized, the combined estimator will be exactly equivalent to
constructing a single estimator on the data set formed by combining the
data sets used to update the respective hermite_estimator inputs.
If the input Hermite estimators are standardized however, then the
equivalence will be approximate.
}
\examples{
hermite_est_1 <- hermite_estimator(N = 10, standardize = FALSE)
hermite_est_1 <- update_batch(hermite_est_1, rnorm(30))
hermite_est_2 <- hermite_estimator(N = 10, standardize = FALSE)
hermite_est_2 <- update_batch(hermite_est_2, rnorm(30))
hermite_combined <- combine_hermite(list(hermite_est_1, hermite_est_2))
}
