% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulome.R
\name{queryRegulome}
\alias{queryRegulome}
\title{This function queries RegulomeDB \url{www.regulomedb.org} web-based tool 
and returns results in a data frame.}
\usage{
queryRegulome(query = NULL, format = "full",
  url = "http://www.regulomedb.org/results", verbose = FALSE)
}
\arguments{
\item{query}{Query (a vector of rsIDs).}

\item{format}{An output format. 
Only \code{full} is currently supported.}

\item{url}{Regulome url address. 
Default: <http://www.regulomedb.org/results>}

\item{verbose}{Verbosing output. Default: FALSE.}
}
\value{
A list of two:
(1) a data frame (table) and
(2) a list of bad SNP IDs. 
Bad SNP ID are those IDs 
that were not found in 1000 Genomes 
Phase 1 data
}
\description{
This function queries RegulomeDB \url{www.regulomedb.org} web-based tool 
and returns results in a data frame.
}
\examples{
data <- queryRegulome(c("rs4791078","rs10048158"))
head(data[["res.table"]])
head(data[["bad.snp.id"]])
}

