% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_written_questions.R
\name{commons_written_questions}
\alias{commons_written_questions}
\title{commons_written_questions}
\usage{
commons_written_questions(mp_id = NULL, answering_department = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE)
}
\arguments{
\item{mp_id}{Requests a member ID and returns a data frame with all written questions asked by that member.}

\item{answering_department}{Accepts a string with a department name or partial name, and returns all written questions by that department. The query acts as a search, so entering <health> will return all questions answered by the Department of Health.}

\item{start_date}{The earliest date to include in the data frame, if calling all divisions, using the date the question was tabled. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame, if calling all divisions, using the date the question was tabled. Defaults to current system date.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Imports data on House of Commons written questions.
}
\examples{
\dontrun{

x <- commons_written_questions(mp_id=410, 'cabinet office')

}
}
\keyword{Commons}
\keyword{House}
\keyword{Questions}
\keyword{Written}
\keyword{of}
