% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lord_vote_record.R
\name{lord_vote_record}
\alias{lord_vote_record}
\title{lord_vote_record}
\usage{
lord_vote_record(peer_id = NULL, lobby = "all", start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE)
}
\arguments{
\item{peer_id}{The ID number of a member of the House of Lords.}

\item{lobby}{Accepts one of 'all', 'content', 'notcontent'. 'content' returns votes where the peer voted 'content', 'notcontent' returns votes where the peer voted 'notcontent', 'all' returns all available votes by the peer. Defaults to 'all'.}

\item{start_date}{The earliest date to include in the data frame. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame. Defaults to current system date.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Accepts an ID number for a member of the House of Commons, and returns a data frame of their votes.
}
\examples{
\dontrun{
x <- lord_vote_record(530, lobby='all')

x <- lord_vote_record(530, lobby='content')

x <- lord_vote_record(530, lobby='notcontent')
}
}
\keyword{divisions}
