% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{cellsToMultiPolygon}
\alias{cellsToMultiPolygon}
\title{Cells to GeoPolygons}
\usage{
cellsToMultiPolygon(cellSet, isLatLng = TRUE)
}
\arguments{
\item{cellSet}{list of string vectors containing to be H3 cell indexes}

\item{isLatLng}{\code{TRUE} (default) if the coordinates are in \code{lat / lng} order.
\code{FALSE} otherwise}
}
\value{
GeoJSON-like MultiPolygon containing the outlines of the set of
input H3 hexagons
}
\description{
Get the outlines of a set of H3 hexagons, returned in GeoJSON-like
MultiPolygon.
}
\examples{

cellsToMultiPolygon(
  cellSet = list(
    list(c("872830828ffffff", "87283082effffff"))
    , list(c("872830828ffffff"))
    )
    , 1L
  )

}
