% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtrends.R
\name{gtrends}
\alias{as.zoo.gtrends}
\alias{gtrends}
\alias{gtrends.default}
\alias{plot.gtrends}
\alias{summary.gtrends}
\title{Google Trends Query}
\usage{
gtrends(query, geo, cat, gprop, session, ...)

\method{gtrends}{default}(query = "", geo = "", cat = "0", gprop = c("",
  "news", "images", "froogle", "youtube"), session, res = c(NA, "1h", "4h",
  "1d", "7d"), start_date = as.Date("2004-01-01"),
  end_date = as.Date(Sys.time()), ...)

\method{summary}{gtrends}(object, ...)

\method{plot}{gtrends}(x, type = c("trend", "geo"), which = 5, ind = 1L,
  ...)

\method{as.zoo}{gtrends}(x, ...)
}
\arguments{
\item{query}{A character vector with the actual Google Trends query keywords.
Multiple keywords are possible using \code{gtrends(c("NHL", "NBA", "MLB", 
"MLS"))}.}

\item{geo}{A character vector denoting geographic regions for the query, 
default to \dQuote{all} for global queries. Multiple regions are possible 
using \code{gtrends("NHL", c("CA", "US"))}.}

\item{cat}{A character denoting the category, defaults to \dQuote{0}.}

\item{gprop}{A character string defining the Google product for which the 
trend query if preformed. Valid options are \dQuote{} (empty string - web 
search), \dQuote{news}, \dQuote{images}, \dQuote{froogle} and 
\dQuote{youtube}. Default is \dQuote{}.}

\item{session}{A valid session which can be created via 
\code{\link{gconnect}}. Users can either supply an explicit handle, or rely
on the helper function \code{.getDefaultConnection()} to retrieve the 
current connection handle.}

\item{...}{Additional parameters passed on in method dispatch.}

\item{res}{Resolution of the trending data to be returned. One of 
\code{c("1h", "4h", "1d", "7d")}. If \code{res} is provided, then 
\code{start_date} and \code{end_date} parameters are ignored. See 
\emph{Query resolution} for more information.}

\item{start_date}{Starting date using yyyy-mm-dd format. Must be greater than
2004-01-01.}

\item{end_date}{Starting date using yyyy-mm-dd format. Must be before than 
current date.}

\item{object}{A \code{\link{gtrends}} object}

\item{x}{A \code{\link{gtrends}} object}

\item{type}{A character variable selecting the type of plot;
permissible values are \sQuote{trends} (which is also the
default), \sQuote{geo}.}

\item{which}{Block number containing the geographical data to plot.}

\item{ind}{A integer selecting the result set in case of multiple
search terms.}
}
\value{
An object of class \sQuote{gtrends} which is list with six elements 
  containing the results.

When \code{type} is equal to \sQuote{trends}, the resulting 
ggplot2 object is returned silently.
}
\description{
The \code{gtrends} default method performs a Google Trends query for the 
\sQuote{query} argument and session \sQuote{session}. Optional arguments for 
geolocation and category can also be supplied.
}
\section{Query resolution}{
 By default, Google returns weekly information when
  the requested data spans a period greater than three months. It is also 
  possible to obtain \emph{daily} and \emph{hourly} information. However, 
  these are only available for a certain period prior to the \emph{current} 
  date.
  
  For instance, \code{1h}, \code{7h}, \code{1d} and \code{7d} denote trends 
  data for the last 1 hour, last four hours, last day and last seven day 
  respectively. Using one of the above \code{res} will return the 
  corresponding hourly data.
  
  Note that data requested for a beriod between one and three months will be 
  returned daily. For a  period greater than three months, data will be 
  always returned weekly.
}

\section{Categories}{
 The package includes a complete list of categories that 
  can be used to narrow requests. These can be accessed using 
  \code{data("categories")}.
}
\examples{
\dontrun{
session <- gconnect("usr@gmail.com", "psw")

gtrends(c("NHL", "NBA", "MLB", "MLS"))

gtrends("NHL", geo = c("CA", "US"))

# Search only for the sport category.
gtrends("NHL", geo = c("CA", "US"), cat = "0-20")

# Trends between 2015-01-01 and 2015-03-01 in Sweeden. Will be daily data.
gtrends("NHL", geo = c("SE"), start_date = "2015-01-01", end_date = "2015-03-01")

# Trends between 2015-01-01 and 2015-04-01 in Sweeden. Will be weekly data.
gtrends("NHL", geo = c("SE"), start_date = "2015-01-01", end_date = "2015-04-01")

# Last 4 hours trends
gtrends("NHL", geo = c("CA"), res = "4h")

# Last 7 days trends
gtrends("NHL", geo = c("CA"), res = "7d")

# Using categories

data("categories")
categories[grepl("music", categories$name, ignore.case = TRUE), ]

gtrends(cat = "1087")
}
data("sport_trend")
plot(sport_trend)
}

