% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_ae_data.R
\name{.complete_ae_data}
\alias{.complete_ae_data}
\title{Create a complete and expanded data frame for tabulating adverse events}
\usage{
.complete_ae_data(
  data,
  id,
  ae,
  soc = NULL,
  by = NULL,
  strata = NULL,
  id_df = NULL,
  by_values = NULL,
  missing_text = "Unknown",
  missing_location = "first"
)
}
\arguments{
\item{data}{Data frame}

\item{id}{String variable name of the patient ID}

\item{ae}{String variable name of the adverse event column}

\item{soc}{Optional string variable name of the system organ class column}

\item{by}{Optional string variable to split results by, e.g. report AEs by grade or attribution}

\item{strata}{Optional string variable to stratify results by,
e.g. report AEs summaries by treatment group}

\item{id_df}{Optional data frame of complete id values and strata to achieve correct
base n for the situation in which not all subjects experience adverse events}

\item{by_values}{Optional vector of complete by values, listed in desired order,
to achieve correct table structure for the situation in which an adverse
event of a certain grade is not observed for a given soc}

\item{missing_text}{String that will be shown for missing levels of \verb{by=},
Default is \code{"Unknown"}}

\item{missing_location}{location where the column summarizing values with
missing levels \verb{by=} will be located in the final table. Must be
one of \verb{c("first", "last", "hide)}. Default is \code{"first"}}
}
\value{
a tibble
}
\description{
Returns a data frame that has an observation for each patient in the study,
with combinations for each ID, SOC, and AE. The returned data frame includes
new logical columns \code{"..ae.."} and  \code{"..soc.."} indicating whether that
row should be included when tabulating the AE table. When multiple
AEs of the same type are observed, the AE with the largest \verb{by=} value
is the observation to be used in the tabulation.
}
\examples{
df_adverse_events \%>\%
  .complete_ae_data(
    id = "patient_id",
    ae = "adverse_event",
    soc = "system_organ_class",
    by = "grade",
    strata = "trt"
  )
}
