% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_scan.R
\name{run_parameter_scan}
\alias{run_parameter_scan}
\title{Parameter Scan}
\usage{
run_parameter_scan(environment, param_values, force = FALSE, outfilename = "")
}
\arguments{
\item{environment}{Either a \link{ModvegeEnvironment} instance with all the site,
management and weather inputs expected by \link{ModvegeSite}\verb{$run()} \strong{or} a
string representing the name of a config file to read in order to
generate the \link{ModvegeEnvironment} with \code{\link[=read_config]{read_config()}}. Note that, in
the latter case, only the first found configuration is used if there are
more than one valid uncommented lines in the config file.}

\item{param_values}{A named list where each key stands for a ModVege
parameter, i.e. a member of \link{ModvegeParameters}\verb{$parameter_names}. Each
list entry then has to be a vector containing the allowed values for the
respective parameter. All possible allowed combinations of these
parameter values are then generated and fed into a ModVege run.}

\item{force}{Boolean. By default (\code{force = FALSE}), the function first
counts the number of parameter combinations that need to be run and asks
the user, if it should proceed. This can be suppressed by letting \code{force  = TRUE}.}

\item{outfilename}{String. If nonempty, the results are stored as an \code{rds}
file with filename \emph{outfilename} using the \code{\link[=saveRDS]{saveRDS()}} function.}
}
\value{
results A list containing an entry for each supplied parameter set
in \emph{param_values}. Each entry is itself a list containing the following
keys:
\describe{
\item{params}{The parameter set that was used to run ModVege for this
entry.}
\item{data}{A list containing for each simulated year a \link{ModvegeSite}
object which was run for the respective year and therefore carries the
respective results.}
}
}
\description{
Run ModVege for a different sets of parameters.
}
\examples{
env = create_example_environment()
# We're creating a trivial list of parameters to explore here in order to 
# prevent the example from requiring a long time to execute. See 
# [create_combinations()] for more realistic uses of param_values.
param_values = list(w_FGA = c(0, 1), w_FGB = c(0, 1))
run_parameter_scan(env, param_values, force = TRUE)

}
\seealso{
\link{ModvegeParameters}, \code{\link[=saveRDS]{saveRDS()}}, \code{\link[=create_combinations]{create_combinations()}}
}
