% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{is_offset}
\alias{is_offset}
\title{Is a model term an offset?}
\usage{
is_offset(terms)
}
\arguments{
\item{terms}{character vector of model terms.}
}
\value{
A logical vector of the same length as \code{terms}.
}
\description{
Given a character vector of model terms, checks to see which, if any, is the model offset.
}
\examples{
library("mgcv")
df <- gamSim(1, n = 400, dist = "normal")
m <- gam(y ~ s(x0) + s(x1) + offset(x0), data = df, method = "REML")
nm <- names(model.frame(m))
nm
is_offset(nm)
}
\author{
Gavin L. Simpson
}
