% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropout.R
\name{ComputeSummaryStatistics}
\alias{ComputeSummaryStatistics}
\title{Compute summary statistics}
\usage{
ComputeSummaryStatistics(
  data,
  pairs = Findno4sUPairs(data),
  coldata = FALSE,
  do.bootstrap = FALSE,
  seed = 1337
)
}
\arguments{
\item{data}{a grandR object}

\item{pairs}{a no4sU pairs list as generated by \link{Findno4sUPairs}}

\item{coldata}{if TRUE, add the coldata table}

\item{do.bootstrap}{if TRUE, also report standard errors of the 4sU dropout estimated via bootstrapping}

\item{seed}{the seed for the random number generator for bootstrapping}
}
\value{
a table of summary statistics including:
\itemize{
  \item{Mean LFC: the mean absolute log2 fold change of each sample vs the corresponding 4sU naive sample}
  \item{4sU dropout: the estimated 4sU dropout percentage}
  \item{p.conv: The 4sU incorporation frequency estimated by GRAND-SLAM}
  \item{Frction labelled: the global NTR}
}
}
\description{
Summary statistics are computed for all samples (or cells).
}
\concept{dropout}
