% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{Normalize}
\alias{Normalize}
\alias{NormalizeFPKM}
\alias{NormalizeRPM}
\alias{NormalizeTPM}
\title{Normalization}
\usage{
Normalize(
  data,
  genes = Genes(data),
  name = "norm",
  slot = "count",
  set.to.default = TRUE,
  size.factors = NULL,
  return.sf = FALSE
)

NormalizeFPKM(
  data,
  genes = Genes(data),
  name = "fpkm",
  slot = "count",
  set.to.default = TRUE,
  tlen = GeneInfo(data, "Length")
)

NormalizeRPM(
  data,
  genes = Genes(data),
  name = "rpm",
  slot = "count",
  set.to.default = TRUE
)

NormalizeTPM(
  data,
  genes = Genes(data),
  name = "tpm",
  slot = "count",
  set.to.default = TRUE,
  tlen = GeneInfo(data, "Length")
)
}
\arguments{
\item{data}{the grandR object}

\item{genes}{compute the normalization w.r.t. these genes (see details)}

\item{name}{the name of the new slot for the normalized data}

\item{slot}{the name of the slot for the data to normalize}

\item{set.to.default}{set the new slot as the default slot}

\item{size.factors}{numeric vector; if not NULL, use these size factors instead of computing size factors}

\item{return.sf}{return the size factors and not a grandR object}

\item{tlen}{the transcript lengths (for FPKM and TPM)}
}
\value{
a new grandR object with a new data slot
}
\description{
Normalizes data in a grandR object and puts the normalized data into a new slot
}
\details{
Normalize will perform DESeq2 normalization, i.e. it will use \link[DESeq2]{estimateSizeFactorsForMatrix}
to estimate size factors, and divide each value by this. If genes are given, size factors will be computed only w.r.t. these genes (but then all genes are normalized).

NormalizeFPKM will compute fragments per kilobase and million mapped reads. If genes are given, the scaling factor
will only be computed w.r.t. these genes (but then all genes are normalized).

NormalizeRPM will compute reads per million mapped reads. If genes are given, the scaling factor
will only be computed w.r.t. these genes (but then all genes are normalized).

NormalizeTPM will compute transcripts per million mapped reads. If genes are given, the scaling factor
will only be computed w.r.t. these genes (but then all genes are normalized).

Genes can be referred to by their names, symbols, row numbers in the gene table, or a logical vector referring to the gene table rows.
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

sars <- Normalize(sars)
DefaultSlot(sars)
}
\seealso{
\code{\link{NormalizeBaseline}}
}
\concept{preprocess}
