% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{Analyses}
\alias{Analyses}
\alias{AddAnalysis}
\alias{DropAnalysis}
\title{Analysis table functions}
\usage{
Analyses(data, description = FALSE)

AddAnalysis(data, name, table, warn.present = TRUE)

DropAnalysis(data, pattern = NULL)
}
\arguments{
\item{data}{A grandR object}

\item{description}{if TRUE, also return the column names of each analysis table (i.e. a list named according to the analyses)}

\item{name}{The user-defined analysis name}

\item{table}{The analysis table to add}

\item{warn.present}{Warn if an analysis with the same name is already present (and then overwrite)}

\item{pattern}{A regular expression that is matched to analysis names}
}
\value{
Either the analysis names or a grandR data with added/removed slots or the metatable to be used with AddAnalysis
}
\description{
Get analysis names and add or remove analyses
}
\details{
The columns in the analysis tables are defined by the analysis method (e.g. "Synthesis","Half-life" and "rmse" by \code{FitKinetics}).
A call to an analysis function might produce more than one table (e.g. because kinetic modeling is done for multiple \link{Condition}s). In this case,
AddAnalysisTable produces more than one analysis table.

\code{AddAnalysis} is usually not called directly by the user, but is
used by analysis methods to add their final result to a grandR object (e.g., \link{FitKinetics},\link{LikelihoodRatioTest},\link{LFC},\link{PairwiseDESeq2}).
}
\section{Functions}{
\itemize{
\item \code{Analyses()}: Obtain the analyses names

\item \code{AddAnalysis()}: Add an analysis table

\item \code{DropAnalysis()}: Remove analyses from the grandR object

}}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

sars <- Normalize(sars)     # default behavior is to update the default slot; this calls AddSlot
Slots(sars)
DefaultSlot(sars)
sars <- DropSlot(sars,"norm")
sars                        # note that the default slot reverted to count

}
\seealso{
\link{Slots}, \link{DefaultSlot}
}
\concept{grandr}
