% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{SE}
\alias{SE}
\title{Standard Errors}
\usage{
SE(object)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}
}
\value{
Standard errors for all parameters as a named numeric vector.
}
\description{
Returns the standard errors of the parameters of a fitted GPPM.
}
\examples{
\donttest{
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
lgcmFit <- fit(lgcm)
stdErrors <- SE(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{fitted.GPPM}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
