% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-sqlite.R
\name{gpkg_update_table}
\alias{gpkg_update_table}
\title{Update a Table by Name}
\usage{
gpkg_update_table(
  x,
  table_name,
  updatecol,
  updatevalue,
  wherecol = NULL,
  wherevector = NULL,
  query_string = FALSE
)
}
\arguments{
\item{x}{A \emph{geopackage} object, path to a GeoPackage or an \emph{SQLiteConnection}.}

\item{table_name}{\emph{character}. Table name.}

\item{updatecol}{\emph{character}. Column to update.}

\item{updatevalue}{\emph{character}, \emph{numeric}, etc.; A scalar value to set.}

\item{wherecol}{\emph{character}. Column used to constrain update.}

\item{wherevector}{\emph{character}, \emph{numeric}, etc.; Vector of values where update should be made.}

\item{query_string}{\emph{logical}. Return SQLite query rather than executing it? Default: \code{FALSE}}
}
\value{
\emph{integer}. Number of rows updated by executing \code{UPDATE} query. Or \code{character} SQL query string if \code{query_string=TRUE}.
}
\description{
For a given table, set column \code{updatecol} to scalar \code{updatevalue} where column \code{wherecol} is in vector \code{wherevector}.
}
