% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterReforms.R
\name{form_boldA}
\alias{form_boldA}
\title{Form the \eqn{((dp)x(dp))} "bold A" matrices related to the VAR processes}
\usage{
form_boldA(p, M, d, all_A)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{the number of time series in the system.}

\item{all_A}{4D array containing all coefficient matrices \eqn{A_{m,i}}, obtained from \code{pick_allA}.}
}
\value{
Returns 3D array containing the \eqn{((dp)x(dp))} "bold A" matrices related to each component VAR-process.
 The matrix \strong{\eqn{A_{m}}} can be obtained by choosing \code{[, , m]}.
}
\description{
\code{form_boldA} creates the "bold A" coefficient matrices related to
  VAR processes.
}
\section{Warning}{

 No argument checks!
}

\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
           \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
