% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneticAlgorithm.R
\name{GAfit}
\alias{GAfit}
\title{Genetic algorithm for preliminary estimation of GMVAR model}
\usage{
GAfit(data, p, M, conditional = TRUE, parametrization = c("intercept",
  "mean"), constraints = NULL, ngen = 200, popsize, smart_mu = min(100,
  round(0.5 * ngen)), initpop = NULL, mu_scale, mu_scale2, omega_scale,
  ar_scale = 1, regime_force_scale = 1, red_criteria = c(0.05, 0.01),
  to_return = c("alt_ind", "best_ind"), minval)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a single time series. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function
should be used. Default is \code{TRUE}.}

\item{parametrization}{\code{"mean"} or \code{"intercept"} determining whether the model is parametrized with regime means \eqn{\mu_{m}} or
intercept parameters \eqn{\phi_{m,0}}, m=1,...,M. Default is \code{"intercept"}.}

\item{constraints}{a size \eqn{(Mpd^2 x q)} constraint matrix \strong{\eqn{C}} specifying general linear constraints
to the autoregressive parameters. We consider constraints of form
(\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}\strong{\eqn{\phi}}\eqn{_{M}) = }\strong{\eqn{C \psi}},
where \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p}) (pd^2 x 1), m=1,...,M}
contains the coefficient matrices and \strong{\eqn{\psi}} \eqn{(q x 1)} contains the constrained parameters.
For example, to restrict the AR-parameters to be the same for all regimes, set \strong{\eqn{C}}=
[\code{I:...:I}]\strong{'} \eqn{(Mpd^2 x pd^2)} where \code{I = diag(p*d^2)}.
Ignore (or set to \code{NULL}) if linear constraints should \strong{not} be employed.}

\item{ngen}{a positive integer specifying the number of generations to be ran through in
the genetic algorithm.}

\item{popsize}{a positive even integer specifying the population size in the genetic algorithm.
Default is \code{10*n_params}.}

\item{smart_mu}{a positive integer specifying the generation after which the random mutations
in the genetic algorithm are "smart". This means that mutating individuals will mostly mutate fairly
close (or partially close) to the best fitting individual (which has the least regimes with time varying
mixing weights practically at zero) so far.}

\item{initpop}{a list of parameter vectors from which the initial population of the genetic algorithm
will be generated from. The parameter vectors should be...
\describe{
  \item{\strong{For regular models:}}{
    Should be size \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
    ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
    \itemize{
      \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
      \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
      \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
    }
  }
  \item{\strong{For constrained models:}}{
    Should be size \eqn{((M(d+d(d+1)/2+1)+q-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\psi}}
    \eqn{,\sigma_{1},...,\sigma_{M},\alpha_{1},...,\alpha_{M-1})}, where:
    \itemize{
      \item \strong{\eqn{\psi}} \eqn{(qx1)} satisfies (\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}
      \strong{\eqn{\phi}}\eqn{_{M}) =} \strong{\eqn{C \psi}}. Here \strong{\eqn{C}} is \eqn{(Mpd^2xq)}
      constraint matrix.
    }
  }
}
Above \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component and
\eqn{\alpha_{m}} is the mixing weight parameter.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks colums
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
The notations are in line with the cited article by \emph{Kalliovirta, Meitz and Saikkonen (2016)}.}

\item{mu_scale}{a size \eqn{(dx1)} vector defining \strong{means} of the normal distributions from which each
mean parameter \eqn{\mu_{m}} is drawn from in random mutations. Default is \code{colMeans(data)}. Note that
mean-parametrization is always used for optimization in \code{GAfit()} - even when \code{parametrization=="intercept"}, but
input (in \code{initpop}) and output (return value) parameter vectors may be intercept-parametrized.}

\item{mu_scale2}{a size \eqn{(dx1)} strictly positive vector defining \strong{standard deviations} of the normal
distributions from which each mean parameter \eqn{\mu_{m}} is drawn from in random mutations.
Default is \code{2*sd(data[,i]), i=1,..,d}.}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart distribution.
Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard deviations
of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit()} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}.}

\item{ar_scale}{a positive real number adjusting how large AR-paramater values are typically generated in some random
mutations. See function \code{random_coefmats2()} for details. This is ignored when estimating constrained models.}

\item{regime_force_scale}{a non-negative real number specifying how much should natural selection favour individuals
with less regimes that have almost all mixing weights (practically) at zero. Set to zero for no favouring or large number
for heavy favouring. Without any favouring the genetic algorithm gets more often stuck in an area of the parameter space where some
regimes are wasted, but with too much favouring the best genes might never mix into the population and the algorithm might
converge poorly. Default is \code{1} and it gives \eqn{2x} larger surviving probabilities for individuals with no wasted
regimes compared to individuals with one wasted regime. Number \code{2} would give \eqn{3x} larger probabilities etc.}

\item{red_criteria}{a length 2 numeric vector specifying the criteria that is used to determine whether a regime is redundant or not.
Any regime \code{m} which satisfies \code{sum(mixingWeights[,m] > red_criteria[1]) < red_criteria[2]*n_obs} will be considered "redundant".
One should be careful when adjusting this argument.}

\item{to_return}{should the genetic algorithm return the best fitting individual which has "positive enough" mixing weights
for as much regimes as possible (\code{"alt_ind"}) or the individual which has the highest log-likelihood in general (\code{"best_ind"}), but
might have more wasted regimes? Default is \code{"alt_ind"}.}

\item{minval}{a real number defining the minimum value of the log-likelihood function that will be considered.
Values smaller than this will be treated as they were \code{minval} and the corresponding individuals will
never survive. The default is \code{-(10^(ceiling(log10(n_obs)) + d) - 1)}.}
}
\value{
Returns estimated parameter vector which has the form described in \code{initpop}.
}
\description{
\code{GAfit} estimates specified GMVAR model using genetic algorithm. It's designed to find
  starting values for gradient based methods.
}
\details{
The genetic algorithm is mostly based on the description by \emph{Dorsey and Mayer (1995)}.
   It uses (slightly modified) individually adaptive crossover and mutation rates described by \emph{Patnaik and Srinivas (1994)}
   and employs (50\%) fitness inheritance discussed by \emph{Smith, Dike and Stegmann (1995)}.
}
\references{
\itemize{
   \item Ansley C.F., Kohn R. 1986. A note on reparameterizing a vector autoregressive
         moving average model to enforce stationarity. \emph{Journal of statistical computation
         and simulation}, \strong{24}:2,  99-106.
   \item Dorsey R. E. and Mayer W. J. 1995. Genetic algorithms for estimation problems with multiple optima,
         nondifferentiability, and other irregular features. \emph{Journal of Business & Economic Statistics},
        \strong{13}, 53-66.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Patnaik L.M. and Srinivas M. 1994. Adaptive Probabilities of Crossover and Mutation in Genetic Algorithms.
         \emph{Transactions on Systems, Man and Cybernetics} \strong{24}, 656-667.
   \item Smith R.E., Dike B.A., Stegmann S.A. 1995. Fitness inheritance in genetic algorithms.
         \emph{Proceedings of the 1995 ACM Symposium on Applied Computing}, 345-350.
 }
}
