% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/glamlasso_predict.R
\name{predict.glamlasso}
\alias{predict.glamlasso}
\title{Make Prediction From a glamlasso Object}
\usage{
\method{predict}{glamlasso}(object, x = NULL, X1 = NULL, X2 = NULL,
  X3 = NULL, ...)
}
\arguments{
\item{object}{An object of Class glamlasso, produced with \code{glamlasso}.}

\item{x}{a matrix of size \eqn{n' \times p} where \eqn{p = p_1p_2p_3} and \eqn{n'} is the number of new data points.}

\item{X1,X2,X3}{Three data matrices of size \eqn{n'_{i} \times p_i}, \eqn{i = 1,2,3}
where \eqn{n'_{i}} is the number of new data points in  the \eqn{i}th dimension.}

\item{...}{ignored}
}
\value{
A list of length \code{nlambda} containing the linear predictors for each  model. If
new covariate data is supplied in one \eqn{n' \times p} matrix \code{x} each
item  is a vector of length \eqn{n'}. If the data is supplied as three
matrices \code{X1, X2, X3} each of size \eqn{n'_{i} \times p_i}, \eqn{i = 1,2,3}
each item is a 3d array of size \eqn{n'_1 \times n'_2 \times n'_3}.
}
\description{
Given new covariate data this function computes the linear predictors
based on the estimated model coefficients in an object produced by the function \code{glamlasso}. Note that the
data can be supplied in two different formats: i) as a \eqn{n' \times p} matrix (\eqn{p = p_1p_2p_3} is the number of model
coefficients and \eqn{n'} is the number of new data points) or ii) as three matrices \code{X1, X2, X3} each of
size \eqn{n_i' \times p_i, i = 1, 2, 3} (\eqn{n_i'} is the number of new marginal data points in the \eqn{i}th dimension).
}
\examples{
n1 <- 65; n2 <- 26; n3 <- 13; p1 <- 13; p2 <- 5; p3 <- 4
X1 <- matrix(rnorm(n1 * p1), n1, p1)
X2 <- matrix(rnorm(n2 * p2), n2, p2)
X3 <- matrix(rnorm(n3 * p3), n3, p3)
Beta <- array(rnorm(p1 * p2 * p3) * rbinom(p1 * p2 * p3, 1, 0.1), c(p1 , p2, p3))
mu <- RH(X3, RH(X2, RH(X1, Beta)))
Y <- array(rnorm(n1 * n2 * n3, mu), dim = c(n1, n2, n3))
fit <- glamlasso(X1, X2, X3, Y, family = "gaussian", iwls = "exact")

##new data in matrix form
x <- matrix(rnorm(p1 * p2 * p3), nrow = 1)
predict(fit, x = x)[[100]]

##new data in tensor component form
X1 <- matrix(rnorm(p1), nrow = 1)
X2 <- matrix(rnorm(p2), nrow = 1)
X3 <- matrix(rnorm(p3), nrow = 1)
predict(fit, X1 = X1, X2 = X2, X3 = X3)[[100]]
}
\author{
Adam Lund
}

