% Generated by roxygen2 (4.0.2): do not edit by hand
\name{aggSEM}
\alias{aggSEM}
\title{Group-level structural equation model search.}
\usage{
aggSEM(data   = "",
       sep    = "",
       header = ,
       out    = "",
       ar     = FALSE,
       plot   = TRUE,
       paths  = NULL)
}
\arguments{
\item{data}{Path to the directory where the data files are located. Each file must contain one matrix for
each individual containing a T (time) by p (number of variables) matrix where the columns represent variables
and the rows represent time.}

\item{sep}{The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, ","
indicates comma delimited.}

\item{header}{Logical. Indicate TRUE for data files with a header.}

\item{out}{The path to the directory where the results will be stored. This directory must be generated
by the user prior to running the function.}

\item{ar}{Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults
to FALSE.}

\item{plot}{Logical. If TRUE, graphs depicting relations among variables of interest will automatically
be created. For aggregate-level plot, red paths represent positive weights and blue paths represent negative weights. Defaults to TRUE.}

\item{paths}{\code{lavaan}-style syntax containing paths with which to begin model estimation. That is, Y~X indicates that Y is regressed on X, or X predicts Y. If no header is used,
then variables should be referred to with V followed (with no separation) by the column number. If a
header is used, variables should be referred to using variable names. To reference lag variables, "lag"
should be added to the end of the variable name with no separation. Defaults to NULL.}
}
\description{
Concatenates all individual-level data files and fits a group model to the data.
}
\details{
In main output directory:
 \itemize{
 \item{all.elements} {Contains information for all paths identified for the concatenated samplel.}
 \item{all.fit} {Contains model fit information for final aggregate-level model.}
 }
 In individual output directory:
 \itemize{
 \item{betas} Directory, contains estimates for aggregate-level model. Names are all_contemp and all_lagged.
 \item{SEs} Directory, contains standard errors for aggregate-level model. Names are all_contemp and all_lagged.
 \item{plots} Directory, contains aggregate-level plot. Red paths represent positive weights and blue paths represent negative weights.
}
}
\examples{
data(ts1,ts2,ts3,ts4,ts5)
input.path  <- file.path(tempdir(),"input")
output.path <- file.path(tempdir(),"output")
dir.create(input.path)
dir.create(output.path)
write.table(ts1,file.path(input.path,"ts1.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts2,file.path(input.path,"ts2.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts3,file.path(input.path,"ts3.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts4,file.path(input.path,"ts4.txt"),col.names=FALSE,row.names=FALSE)
write.table(ts5,file.path(input.path,"ts5.txt"),col.names=FALSE,row.names=FALSE)
aggSEM(data   = input.path,
       sep    = "",
       header = FALSE,
       out    = output.path,
       ar     = TRUE,
       plot   = TRUE,
       paths  = NULL)
}
\author{
Stephanie Lane
}

