% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsj.R
\name{theme_wsj}
\alias{theme_wsj}
\title{Wall Street Journal theme}
\usage{
theme_wsj(base_size = 12, color = "brown", base_family = "sans",
  title_family = "mono")
}
\arguments{
\item{base_size}{base font size}

\item{color}{The background color of plot. One of \code{'brown',
'gray', 'green', 'blue'}, the names of values in
\code{ggthemes_data$wsj$bg}.}

\item{base_family}{base font family}

\item{title_family}{Plot title font family.}
}
\description{
Theme based on the plots in \emph{The Wall Street Journal}.
}
\examples{
library("ggplot2")
p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, colour=factor(gear))) +
     facet_wrap(~am) +
     ggtitle('Diamond Prices')
p + scale_colour_wsj('colors6', '') + theme_wsj()
# Use a gray background instead#'
p + scale_colour_wsj('colors6', '') + theme_wsj(color = "gray")
}
\references{
\url{https://twitter.com/WSJGraphics}

\url{https://pinterest.com/wsjgraphics/wsj-graphics/}
}

