#' Sequence data
#' 
#' @name sequences
#' @title peptide sequence data
#' @description sequences showing the amino acid usage in the adenylate kinase lid available through biovis redesign contest 2013, see \url{http://biovis.net/year/2013/info/redesign-contest}
#' published in Wong, B. Nat Methods 7, 889 (2011)
#' @docType data
#' @usage data(sequences)
NULL

#' alphabet polygon data
#' 
#' The alphabet polygon data is based on the font Helvetica. Upper and lower case letters are included as well as digits.
#' Other alphabet data are `alphabet_comic` (based on Comic Sans MS), `alphabet_xkcd` (based on the xkcd font),  and `alphabet_braille` (based on Swell Braille)
#' 
#' @name alphabet
#' @title alphabet polygon data
#' @description polygons of upper and lower case letters and digits 0-9
#' @docType data
#' @usage data(alphabet)
NULL

#' @rdname alphabet
#' @name alphabet_comic
#' @docType data
#' @usage data(alphabet_comic)
NULL

#' @rdname alphabet
#' @name alphabet_xkcd
#' @docType data
#' @usage data(alphabet_xkcd)
NULL

#' @rdname alphabet
#' @name alphabet_braille
#' @docType data
#' @usage data(alphabet_braille)
NULL


#' Amino acid properties
#' 
#' @name aacids
#' @title properties of amino acids
#' @description properties of amino acids: polarity and water affiliation 
#' @docType data
#' @usage data(aacids)
NULL