% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe_options.R
\name{girafe_options}
\alias{girafe_options}
\title{Set girafe options}
\usage{
girafe_options(x, ...)
}
\arguments{
\item{x}{girafe object.}

\item{...}{set of options defined by calls to \code{opts_*} functions or
to sizingPolicy from htmlwidgets (this won't have any effect within a
shiny context).}
}
\description{
Defines the animation options related to
a \code{\link[=girafe]{girafe()}} object.
}
\examples{
library(ggplot2)
library(htmlwidgets)

dataset <- mtcars
dataset$carname = row.names(mtcars)

gg_point = ggplot( data = dataset,
    mapping = aes(x = wt, y = qsec, color = disp,
    tooltip = carname, data_id = carname) ) +
  geom_point_interactive() + theme_minimal()

x <- girafe(ggobj = gg_point)
x <- girafe_options(x = x,
    opts_tooltip(opacity = .7),
    opts_zoom(min = .5, max = 4),
    sizingPolicy(defaultWidth = "100\%", defaultHeight = "300px"),
    opts_hover(css = "fill:red;stroke:orange;r:5pt;") )

if(interactive()){
  print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}

Other girafe animation options: 
\code{\link{opts_hover}()},
\code{\link{opts_selection}()},
\code{\link{opts_sizing}()},
\code{\link{opts_toolbar}()},
\code{\link{opts_tooltip}()},
\code{\link{opts_zoom}()}
}
\concept{girafe animation options}
