% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{ggiraph}
\alias{ggiraph}
\title{ggiraph}
\usage{
ggiraph(code, pointsize = 12, width = 6, height = 6,
  hover_css = "{fill:orange;}", ...)
}
\arguments{
\item{code}{Plotting code to execute}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width}{widget width}

\item{height}{widget height}

\item{hover_css}{css to apply when mouse is hover and element with a data-id attribute}

\item{...}{arguments passed on to \code{dsvg}}
}
\description{
Create an interactive graphic
to be used in a web browser.
}
\examples{
# ggiraph simple example -------
# create dataset
dataset = iris
dataset$tooltip = dataset$Species
dataset$clickjs = paste0("function() {alert('",dataset$Species, "')}" )

# plots
gg_point = ggplot(dataset, aes(x = Sepal.Length, y = Petal.Width,
		color = Species, tooltip = tooltip, onclick = clickjs) ) +
	geom_point_interactive()

ggiraph(code = {print(gg_point)})
}
\seealso{
\code{\link{geom_path_interactive}},
\code{\link{geom_point_interactive}},
\code{\link{geom_polygon_interactive}},
\code{\link{geom_rect_interactive}},
\code{\link{geom_segment_interactive}}
}

