% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_number_hdx.R
\name{format_number_hdx}
\alias{format_number_hdx}
\title{Format numbers in HDX style}
\usage{
format_number_hdx(x, additional_prefix)
}
\arguments{
\item{x}{Numeric vector to format}

\item{additional_prefix}{Additional prefix to add to string, that will come
between \code{sign_prefix} and the number. For example, \code{"$"} could produce a
return value of \verb{-$1.1K}.}
}
\value{
Character vector of formatted strings
}
\description{
Does the formatting found in \code{label_number_hdx}.
}
\details{
Just for continuity, values are labeled with T for trillion, and that is the
maximum formatting available, anything above the trillions will continue to be
truncated to report in the trillions.

Deals with negative values in case those ever need to be formatted in similar
manners. Also ensures that rounding is performed so numbers look correct.
Not to be used for percents, which should just use \code{\link[scales:label_percent]{scales::label_percent()}}.

Designed like the \verb{scales::} family of label functions, the return value of
\code{label_number_hdx} is a function, based on the \code{additional_prefix}. So you
should pass it in to \code{scales_...()} \code{labels} parameter in the same way as
\code{scales_...()}
}
