% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_number_hdx.R
\name{label_number_hdx}
\alias{label_number_hdx}
\title{Label numbers in HDX key figures style}
\usage{
label_number_hdx(additional_prefix = "")
}
\arguments{
\item{additional_prefix}{Additional prefix to add to string, that will come
between \code{sign_prefix} and the number. For example, \code{"$"} could produce a
return value of \verb{-$1.1K}.}
}
\value{
Returns a "labelling" function, in the same way as \code{scales::label_...()}
functions work, i.e. a function that takes \code{x} and returns a labelled character
vector of \code{length(x)}.
}
\description{
Formats numeric vector in the Centre style for key figures, which abbreviates
numbers 1,000 and above to X.YK, 10,000 and above to XYK, 100,000 and above
to XYZK, and the same for 1,000,000 and above, replacing the K with an M, and
the same for B. Details of the data viz style can be found in the
\href{https://data.humdata.org/dataviz-guide/dataviz-elements/#/data-visualization/text}{visualization guidelines}
}
\details{
Just for continuity, values are labeled with T for trillion, and that is the
maximum formatting available, anything above the trillions will continue to be
truncated to report in the trillions.

Deals with negative values in case those ever need to be formatted in similar
manners. Also ensures that rounding is performed so numbers look correct.
Not to be used for percents, which should just use \code{\link[scales:label_percent]{scales::label_percent()}}.

Designed like the \verb{scales::} family of label functions, the return value of
\code{label_number_hdx} is a function, based on the \code{additional_prefix}. So you
should pass it in to \code{scales_...()} \code{labels} parameter in the same way as
\code{scales_...()}
}
\examples{
library(ggplot2)

# discrete scaling
p <- ggplot(txhousing) +
  geom_point(
    aes(
      x = median,
      y = volume
    )
  )

p

p +
  scale_x_continuous(
    labels = label_number_hdx("$")
  ) +
  scale_y_continuous(
    labels = label_number_hdx()
  )

}
