% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdx_geom_defaults.R
\name{hdx_geom_defaults}
\alias{hdx_geom_defaults}
\title{Default HDX geometry aesthetics}
\usage{
hdx_geom_defaults()
}
\value{
A list of geometry defaults.
}
\description{
Default geometry aesthetics fitting the HDX design guide. Used in \code{\link[=gghdx]{gghdx()}} to
set default fill, color, size, and point geometry defaults, which is not possible
using just \code{\link[=theme_hdx]{theme_hdx()}}.
}
\details{
Derived from the
\href{https://github.com/Mikata-Project/ggthemr/}{ggthemr} methods.
}
\examples{
library(purrr)
library(ggplot2)

# updating geom defaults (like default color of a point or fill for bar)
purrr::walk(
  hdx_geom_defaults(),
  ~ do.call(what = ggplot2::update_geom_defaults, args = .),
)

p <- ggplot(mtcars) +
  geom_point(
    aes(
      x = mpg,
      y = hp
    )
  )

# see the points are automatically in HDX sapphire
p

# need to reset back to the default geometries
purrr::walk(
  ggplot2_geom_defaults(),
  ~ do.call(what = ggplot2::update_geom_defaults, args = .)
)

# now the points are back to default black
p

}
\seealso{
\itemize{
\item \code{\link[=gghdx]{gghdx()}} for automatically setting default geometries,
along with other styling.
\item \code{\link[=ggplot2_geom_defaults]{ggplot2_geom_defaults()}} for the ggplot2 default aesthetics.
}
}
