% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation-partition.R
\name{partition}
\alias{partition}
\title{Partition a layer into subgroups (Layer operation)}
\usage{
partition(object, partition)
}
\arguments{
\item{object}{One of:
\itemize{
\item A \link{layer-like} object: applies this operation to the layer.
\item A missing argument: creates an \link{operation}
\item Anything else: creates an \link{operation}, passing \code{object} along to the
\code{partition} argument
}}

\item{partition}{One of:
\itemize{
\item A list of quosures, such as returned by \code{\link[=vars]{vars()}}, giving a (possibly multi-)
column expression for the \code{partition} aesthetic. These expressions are
combined using \code{\link[=interaction]{interaction()}} to be passed on to \code{aes(partition = ...)}
\item A one-sided formula, giving a single-column expression for the \code{partition}
aesthetic, which is passed on to \code{aes_(partition = ...)}.
}}
}
\value{
A \link{layer-like} object (if \code{object} is \link{layer-like}) or an \link{operation} (if not).
}
\description{
A layer \link{operation} for adding a \code{partition} aesthetic to a \link{layer}.
}
\details{
This is a shortcut for setting the \code{partition} aesthetic of a \link{layer}.
\itemize{
\item \code{partition(~ XXX)} is roughly equivalent to \code{adjust(aes(partition = XXX))}
\item \code{partition(vars(X, Y, ...))} is roughly equivalent to \code{adjust(aes(partition = interaction(X, Y, ...)))}
}

When a \link{layer} with a \code{partition} aesthetic is used by the following
\link{operation}s, the effects of the operations are applied across groups:
\itemize{
\item \code{\link[=blend]{blend()}}: Blends graphical objects within the subgroups defined by the
partition together using normal (\code{"over"}) blending before applying its
blend between subgroups.
}
}
\examples{
\dontshow{old_options = options(ggblend.check_blend = FALSE)}
library(ggplot2)

# create two versions of a dataset, where draw order can affect output
set.seed(1234)
df_a = data.frame(x = rnorm(500, 0), y = rnorm(500, 1), set = "a")
df_b = data.frame(x = rnorm(500, 1), y = rnorm(500, 2), set = "b")
df_ab = rbind(df_a, df_b) |>
  transform(order = "draw a then b")
df_ba = rbind(df_b, df_a) |>
  transform(order = "draw b then a")
df = rbind(df_ab, df_ba)

# Using the "multiply" blend mode, draw order does not matter, but
# the "multiply" blend is applied to all points, creating dark regions
# outside the intersection:
df |>
  ggplot(aes(x, y, color = set)) +
  geom_point(size = 3, alpha = 0.5) |> blend("multiply") +
  scale_color_brewer(palette = "Set1") +
  facet_grid(~ order)

# By partitioning (either through |> partition(vars(set)) or aes(partition = set))
# we will blend using the default blend mode (over) first, then we can apply the
# "multiply" blend just between the two sets, so the regions outside the
# intersection are not blended using "multiply":
df |>
  ggplot(aes(x, y, color = set, partition = set)) +
  geom_point(size = 3, alpha = 0.5) |> blend("multiply") +
  scale_color_brewer(palette = "Set1") +
  facet_grid(~ order)
\dontshow{options(old_options)}
}
\seealso{
\link{operation} for a description of layer operations.

Other layer operations: 
\code{\link{adjust}},
\code{\link{affine_transform}},
\code{\link{blend}},
\code{\link{copy}},
\code{\link{nop}}
}
\concept{layer operations}
