% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active.R
\name{active}
\alias{active}
\title{Plot Adding Context Settings}
\usage{
active(order = NA_integer_, use = NA, name = NA_character_)
}
\arguments{
\item{order}{An integer specifying the order of the plot area within the
layout.}

\item{use}{A logical (\code{TRUE}/\code{FALSE}) indicating whether to set the
active context to the current plot when added to a layout. If \code{TRUE},
any subsequent \code{ggplot} elements will be applied to this plot.}

\item{name}{A string specifying the plot's name, useful for switching active
contexts through the \code{what} argument in functions like
\code{\link[=quad_anno]{quad_anno()}}/\code{\link[=stack_switch]{stack_switch()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These settings control the behavior of the plot when added to a layout, as
well as the arrangement of individual plot areas within the layout.
}
\details{
By default, the active context is set only for functions that add plot areas.
This allows other \code{ggplot2} elements-such as \code{geoms}, \code{stats}, \code{scales}, or
\code{themes}- to be seamlessly added to the current plot area.

The default ordering of the plot areas is from top to bottom or from left to
right, depending on the layout orientation. However, users can customize this
order using the \code{order} argument.
}
