% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-magick.R
\name{raster_magick}
\alias{raster_magick}
\title{Rasterize the ggplot layers}
\usage{
raster_magick(
  x,
  magick = NULL,
  ...,
  res = NULL,
  interpolate = FALSE,
  vp = NULL
)
}
\arguments{
\item{x}{An object to rasterize, can be a \code{\link[grid:grid.grob]{grob()}},
\code{\link[ggplot2:layer]{layer()}}, \code{\link[ggplot2:ggplot]{ggplot()}}, or a list of such
objects.}

\item{magick}{A function (purrr-style formula is accepted) that takes an
\code{\link[magick:editing]{image_read()}} object as input and returns an object
compatible with \code{\link[grDevices:as.raster]{as.raster()}}. You can use any of
the \verb{image_*()} functions from the \strong{magick} package to process the raster
image.}

\item{...}{These dots are for future extensions and must be empty.}

\item{res}{An integer sets the desired resolution in pixels.}

\item{interpolate}{
    A logical value indicating whether to linearly interpolate the
    image (the alternative is to use nearest-neighbour interpolation,
    which gives a more blocky result).
  }

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
An object with the same class of the input.
}
\description{
The function rasterizes input graphical objects (e.g., grob, layer, ggplot)
and optionally processes the resulting raster using magick, a powerful image
manipulation library. This allows for advanced graphical transformations
directly within the plotting pipeline.
}
\examples{
# Currently, `magick` package require R >= 4.1.0
if (requireNamespace("magick")) {
    # data generated code was copied from `ComplexHeatmap`
    set.seed(123)
    small_mat <- matrix(rnorm(56), nrow = 7)
    rownames(small_mat) <- paste0("row", seq_len(nrow(small_mat)))
    colnames(small_mat) <- paste0("column", seq_len(ncol(small_mat)))
    ggheatmap(small_mat, aes(.x, .y), filling = NULL) +
        raster_magick(geom_tile(aes(fill = value)), res = 20)

    ggheatmap(small_mat, aes(.x, .y), filling = NULL) +
        # Use `magick::filter_types()` to check available `filter` arguments
        raster_magick(
            geom_tile(aes(fill = value)),
            magick = function(image) {
                magick::image_resize(image,
                    geometry = "50\%x", filter = "Lanczos"
                )
            }
        )
}
}
\seealso{
\code{\link[=magickGrob]{magickGrob()}}
}
