% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpar.R
\name{pmx_gpar}
\alias{pmx_gpar}
\title{Handling pmx Graphical parameters}
\usage{
pmx_gpar(
  is.title,
  labels,
  axis.title,
  which_pages,
  print,
  axis.text,
  ranges,
  is.smooth,
  smooth,
  is.band,
  band,
  is.draft,
  draft,
  discrete,
  is.identity_line,
  identity_line,
  smooth_with_bloq,
  scale_x_log10,
  scale_y_log10,
  color.scales,
  is.legend,
  legend.position
)
}
\arguments{
\item{is.title}{\code{logical} if TRUE then a title is used for the plot}

\item{labels}{list of labels, like title, subtitle, x , y}

\item{axis.title}{list or element_text (same as ggplot2 axis.title theme)}

\item{which_pages}{page(s) to display; if "all" display all pages,
if 1 display first page, if c(1,2) display first and second pages}

\item{print}{if TRUE the ouptut will be a print not a ggplot2. This
is useful for rmarkdwon output to avoid verbose list index print.}

\item{axis.text}{list or element_text (same as ggplot2 axis.text theme)}

\item{ranges}{limits of x/y ranges}

\item{is.smooth}{logical if set to TRUE add smooth layer}

\item{smooth}{smooth layer parameters}

\item{is.band}{logical if TRUE add horizontal band}

\item{band}{horizontal band parameters}

\item{is.draft}{logical if TRUE add draft layer}

\item{draft}{draft layer parameters}

\item{discrete}{logical if TRUE x axis is discrete(FALSE by default)}

\item{is.identity_line}{\code{logical} if TRUE add y=x line}

\item{identity_line}{\code{list} y=x aes properties}

\item{smooth_with_bloq}{\code{logical} if TRUE perform spline in plots with BLOQ data}

\item{scale_x_log10}{logical if TRUE add scale_x_log10 layer}

\item{scale_y_log10}{logical if TRUE add scale_y_log10 layer}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{is.legend}{\code{logical} if TRUE x axis is discrete(FALSE by default)}

\item{legend.position}{\code{charcater} legend position it takes the same value as the equivalent ggplot2 parameter}
}
\value{
An object of class \code{"pmx_gpar"}.
}
\description{
Handling pmx Graphical parameters
}
\details{
This object contains all general graphic settings. It used internally by all
pmx_plot(generic function) to set the default behavior.
}
