% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistar_add_facts.R
\name{add_facts}
\alias{add_facts}
\alias{add_facts.multistar}
\title{Add a fact table to a \code{multistar}}
\usage{
add_facts(
  ms,
  fact_name = NULL,
  fact_table = NULL,
  measures = NULL,
  agg_functions = NULL,
  nrow_agg = "nrow_agg"
)

\method{add_facts}{multistar}(
  ms,
  fact_name = NULL,
  fact_table = NULL,
  measures = NULL,
  agg_functions = NULL,
  nrow_agg = "nrow_agg"
)
}
\arguments{
\item{ms}{A \code{multistar} object.}

\item{fact_name}{A string, name of fact table.}

\item{fact_table}{A \code{tibble}, fact table.}

\item{measures}{A vector of measure names.}

\item{agg_functions}{A vector of aggregation function names. If none is
indicated, the default is SUM. Additionally they can be MAX or MIN.}

\item{nrow_agg}{A string, measurement name for the number of rows aggregated.
If it does not exist, it is added to the table.}
}
\value{
A \code{multistar}.
}
\description{
To add a fact table to a \code{multistar} object, we must indicate the name that
we give to the facts, the \code{tibble} that contains the data and a vector of
attribute names corresponding to the measures.
}
\details{
Associated with each measurement, an aggregation function is required, which
by default is SUM. It that can be SUM, MAX or MIN. Mean is not considered
among the possible aggregation functions: The reason is that calculating the
mean by considering subsets of data does not necessarily yield the mean of
the total data.

An additional measurement, \code{nrow_agg}, corresponding to the number of
aggregated rows is always added which, together with SUM, allows us to obtain
the mean if needed. As the value of this parameter, you can specify an
attribute of the table or the name that you want to assign to it (if it does
not exist, it is added to the table).
}
\examples{

ms <- multistar() |>
  add_facts(
    fact_name = "mrs_age",
    fact_table = mrs_fact_age,
    measures = "n_deaths",
    nrow_agg = "count"
  ) |>
  add_facts(
    fact_name = "mrs_cause",
    fact_table = mrs_fact_cause,
    measures = c("pneumonia_and_influenza_deaths", "other_deaths"),
    nrow_agg = "nrow_agg"
  )

}
\seealso{
Other multistar functions: 
\code{\link{add_dimension}()},
\code{\link{multistar}()},
\code{\link{relate_dimension}()}
}
\concept{multistar functions}
