% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOMemberName.R
\docType{class}
\name{ISOMemberName}
\alias{ISOMemberName}
\title{ISOMemberName}
\format{\code{\link{R6Class}} object.}
\usage{
ISOMemberName
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOMemberName
}
\description{
ISOMemberName
}
\section{Fields}{

\describe{
\item{\code{aName}}{[\code{\link{character}}] member name}

\item{\code{attributeType}}{[\code{\link{ISOTypeName}}|\code{\link{character}}] attribute type}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, aName, attributeType)}}{
   This method is used to instantiate an \code{\link{ISOMemberName}}
 }
 \item{\code{setName(aName)}}{
   Set the aName, object of class \code{character}. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setAttributeType(attributeType, locales)}}{
   Set the attribute type, object of class \code{ISOTypeName} or \code{character}
   Locale names can be specified as \code{list} with the \code{locales} argument.
 }
}
}

\references{
ISO/TS 19103:2005 Geographic information -- Conceptual schema language
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{record}
