% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{svi}
\alias{svi}
\title{Valley Fluid Retention Index}
\usage{
svi(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the valley fluid
retention index.
}
\description{
Determines the valley fluid retention index (Svi). This
value is the void volume (area under the bearing area
curve) in the 'valley' zone. See Figure 2a from Kedron
et al. (2018) for more details.
}
\examples{
# import raster image
data(normforest)

# determine the valley fluid retention index
Svi <- svi(normforest)
}
