% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingwindow.R
\name{window_metric}
\alias{window_metric}
\title{Calculate Texture Metric for Single Pixel}
\usage{
window_metric(
  x,
  coords,
  window_type = "square",
  size = 11,
  metric,
  args = NULL
)
}
\arguments{
\item{x}{A raster or matrix.}

\item{coords}{Dataframe. Coordinates of window edges.}

\item{window_type}{Character. Type of window, either circular or square.}

\item{size}{Numeric. Edge length or diameter of window in number of pixels.}

\item{metric}{Character. Metric to calculate for each window. Metrics
from the geodiv package are listed below.}

\item{args}{List. Arguments from function to be applied over each window
(e.g., list(threshold = 0.2)).}
}
\value{
A raster with pixel values representative of the metric
value for the window surrounding that pixel.
}
\description{
Calculates the various texture metrics over a window centered
on an individual pixel.
}
\details{
Metrics from geodiv package:
\enumerate{
   \item{\code{'sa'}: average surface roughness}
   \item{\code{'sq'}: root mean square roughness}
   \item{\code{'s10z'}: ten-point height}
   \item{\code{'sdq'}: root mean square slope of surface, 2-point method}
   \item{\code{'sdq6'}: root mean square slope of surface, 7-point method}
   \item{\code{'sdr'}: surface area ratio}
   \item{\code{'sbi'}: surface bearing index}
   \item{\code{'sci'}: core fluid retention index}
   \item{\code{'ssk'}: skewness}
   \item{\code{'sku'}: kurtosis}
   \item{\code{'sds'}: summit density}
   \item{\code{'sfd'}: 3d fractal dimension}
   \item{\code{'srw'}: dominant radial wavelength, radial wavelength index, mean half wavelength}
   \item{\code{'std'}: angle of dominating texture, texture direction index}
   \item{\code{'svi'}: valley fluid retention index}
   \item{\code{'stxr'}: texture aspect ratio}
   \item{\code{'ssc'}: mean summit curvature}
   \item{\code{'sv'}: maximum valley depth}
   \item{\code{'sph'}: maximum peak height}
   \item{\code{'sk'}: core roughness depth}
   \item{\code{'smean'}: mean peak height}
   \item{\code{'svk'}: reduced valley depth}
   \item{\code{'spk'}: reduced peak height}
   \item{\code{'scl'}: correlation length}
   \item{\code{'sdc'}: bearing area curve height interval}
}
}
\note{
Note that if calculating the metric at the edge of a raster or matrix,
the input raster/matrix must be padded. This can be done using the \code{pad_edges}
function.
}
