% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.ridge.R
\name{pca}
\alias{pca}
\alias{pca.ridge}
\title{Transform Ridge Estimates to PCA Space}
\usage{
pca(x, ...)
}
\arguments{
\item{x}{A \code{ridge} object, as fit by \code{\link{ridge}}}

\item{\dots}{Other arguments passed down. Not presently used in this
implementation.}
}
\value{
An object of class \code{c("ridge", "pcaridge")}, with the same
       components as the original \code{ridge} object.
}
\description{
The function \code{pca.ridge} transforms a \code{ridge} object from
parameter space, where the estimated coefficients are \eqn{\beta_k} with
covariance matrices \eqn{\Sigma_k}, to the principal component space defined
by the right singular vectors, \eqn{V}, of the singular value decomposition
of the scaled predictor matrix, \eqn{X}.

In this space, the transformed coefficients are \eqn{V \beta_k}, with
covariance matrices \deqn{V \Sigma_k V^T}.

This transformation provides alternative views of ridge estimates in
low-rank approximations. In particular, it allows one to see where the
effects of collinearity typically reside --- in the smallest PCA dimensions.
}
\examples{

longley.y <- longley[, "Employed"]
longley.X <- data.matrix(longley[, c(2:6,1)])

lambda <- c(0, 0.005, 0.01, 0.02, 0.04, 0.08)
lridge <- ridge(longley.y, longley.X, lambda=lambda)

plridge <- pca(lridge)
traceplot(plridge)
pairs(plridge)
# view in space of smallest singular values
plot(plridge, variables=5:6)


}
\references{
Friendly, M. (2013). The Generalized Ridge Trace Plot:
Visualizing Bias \emph{and} Precision. \emph{Journal of Computational and
Graphical Statistics}, \bold{22}(1), 50-68,
doi:10.1080/10618600.2012.681237,
\url{https://www.datavis.ca/papers/genridge-jcgs.pdf}
}
\seealso{
\code{\link{ridge}}
}
\author{
Michael Friendly
}
\keyword{dplot}
\keyword{multivariate}
