% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGE_Plot.R
\name{GGEPlot}
\alias{GGEPlot}
\title{GGE biplots with \pkg{ggplot2}}
\usage{
GGEPlot(
  GGEModel,
  type = "Biplot",
  d1 = 1,
  d2 = 2,
  selectedE = NA,
  selectedG = NA,
  selectedG1 = NA,
  selectedG2 = NA,
  colGen = "gray47",
  colEnv = "darkred",
  colSegment = "gray30",
  colHull = "gray30",
  sizeGen = 4,
  sizeEnv = 4,
  largeSize = 4.5,
  axis_expand = 1.2,
  axislabels = TRUE,
  axes = TRUE,
  limits = TRUE,
  titles = TRUE,
  footnote = TRUE
)
}
\arguments{
\item{GGEModel}{An object of class \code{GGEModel}.}

\item{type}{type of biplot to produce.
\itemize{
 \item \code{"Biplot"}: Basic biplot.
 \item \code{"Selected Environmen"t}: Ranking of cultivars based on
 their performance in any given environment.
 \item \code{"Selected Genotype"}: Ranking of environments based on the
 performance of any given cultivar.
 \item \code{"Relationship Among Environments"}.
 \item \code{"Comparison of Genotype"}.
 \item \code{"Which Won Where/What"}: Identifying the 'best'
 cultivar in each environment.
 \item \code{"Discrimination vs. representativeness"}: Evaluating the
 environments based on both discriminating ability and representativeness.
 \item \code{"Ranking Environments"}: Ranking environments with respect to
 the ideal environment.
 \item \code{"Mean vs. stability"}: Evaluating cultivars based on both average
 yield and stability.
 \item \code{"Ranking Genotypes"}: Ranking genotypes with respect to the
 ideal genotype.}}

\item{d1}{PCA component to plot on x axis. Defaults to 1.}

\item{d2}{PCA component to plot on y axis. Defaults to 2.}

\item{selectedE}{name of the environment to evaluate when `type="Selected
Environment"`.}

\item{selectedG}{name of the genotype to evaluate when `type="Selected
Genotype"`.}

\item{selectedG1, }{name of the genotype to compare to `selectedG2`  when
`type="Comparison of Genotype"`.}

\item{selectedG2, }{name of the genotype to compare to `selectedG1`  when
`type="Comparison of Genotype"`.}

\item{colGen}{genotype attributes colour. Defaults to `"gray47"`.}

\item{colEnv}{environment attributes colour. Defaults to `"darkred"`.}

\item{colSegment}{segment or circle lines colour. Defaults to `"gray30"`.}

\item{colHull}{hull colour when `type="Which Won Where/What"`. Defaults to
"gray30".}

\item{sizeGen}{genotype labels text size. Defaults to 4.}

\item{sizeEnv}{environment labels text size. Defaults to 4.}

\item{largeSize}{larger labels text size to use for two selected genotypes in
`type="Comparison of Genotype"`, and for the outermost genotypes in
`type="Which Won Where/What"`. Defaults to 4.5.}

\item{axis_expand}{multiplication factor to expand the axis limits by to
enable fitting of labels. Defaults to 1.2.}

\item{axislabels}{logical, if this argument is `TRUE` labels for axes are
included. Defaults to `TRUE`.}

\item{axes}{logical, if this argument is `TRUE` x and y axes going through the
origin are drawn. Defaults to `TRUE`.}

\item{limits}{logical, if this argument is `TRUE` the axes are re-scaled.
Defaults to `TRUE`.}

\item{titles}{logical, if this argument is `TRUE` a plot title is included.
Defaults to `TRUE`.}

\item{footnote}{logical, if this argument is `TRUE` a footnote is included.
Defaults to `TRUE`.}
}
\value{
A biplot of class \code{ggplot}
}
\description{
GGE biplots are used for visual examination of the relationships
 between test environments, genotypes, and genotype-by-environment
 interactions. `GGEPlot()` produces a biplot as an object of class 'ggplot',
 using the output of  the \code{\link[geneticae]{GGEmodel}} function.
 Several types of biplots are offered which focus on different aspects of the
 analysis. Customization options are also included. This function is a
 modification of \code{\link[GGEBiplots]{GGEPlot}} from the
 href{https://CRAN.R-project.org/package=GGEBiplots}{GGEBiplots package}.
}
\examples{
 library(geneticae)

 # Data without replication
 data(yan.winterwheat)
 GGE1 <- GGEmodel(yan.winterwheat, centering = "tester")
 GGEPlot(GGE1)

 # Data with replication
 data(plrv)
 GGE2 <- GGEmodel(plrv, genotype = "Genotype", environment = "Locality",
                  response = "Yield", rep = "Rep", centering = "tester")
 GGEPlot(GGE2)

}
\references{
Yan W, Kang M (2003). \emph{GGE Biplot Analysis: A Graphical Tool
 for Breeders, Geneticists, and Agronomists}. CRC Press.

Sam Dumble (2017). GGEBiplots: GGE Biplots with 'ggplot2'. R
 package version 0.1.1. \url{https://CRAN.R-project.org/package=GGEBiplots}
}
\keyword{Biplot}
\keyword{GGE}
