% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_psiFUN_funs.R
\docType{methods}
\name{grab_psiFUN}
\alias{grab_psiFUN}
\alias{grab_psiFUN.glm}
\alias{grab_psiFUN.geeglm}
\alias{grab_psiFUN.merMod}
\title{Grab estimating functions from a model object}
\usage{
grab_psiFUN(object, ...)

\method{grab_psiFUN}{glm}(object, data, ...)

\method{grab_psiFUN}{geeglm}(object, data, ...)

\method{grab_psiFUN}{merMod}(object, data, numderiv_opts = NULL, ...)
}
\arguments{
\item{object}{the object from which to extrace \code{psiFUN}}

\item{...}{additonal arguments passed to other methods}

\item{data}{the data to use for the estimating function}

\item{numderiv_opts}{a list of arguments passed to \code{numDeriv::grad}}
}
\description{
Grab estimating functions from a model object
}
\section{Methods (by class)}{
\itemize{
\item \code{glm}: Create estimating equation function from a \code{glm} object

\item \code{geeglm}: Create estimating equation function from a \code{geeglm} object

\item \code{merMod}: Create estimating equation function from a \code{merMod} object
}}

\examples{

\dontrun{
library(geepack)
data('ohio')

glmfit  <- glm(resp ~ age, data = ohio,
               family = binomial(link = "logit"))
geefit  <- geeglm(resp ~ age, data = ohio, id = id,
                  family = binomial(link = "logit"))
glmmfit <- glmer(resp ~ age + (1|id), data = ohio,
                 family = binomial(link = "logit"))
example_ee <- function(data, model){
 f <- grab_psiFUN(model, data)
 function(theta){
  f(theta)
 }
}

m_estimate(
  estFUN = example_ee,
  data = ohio,
  compute_roots = FALSE,
  units = 'id',
  roots = coef(glmfit),
  outer_args = list(model = glmfit))
m_estimate(
  estFUN = example_ee,
  data = ohio,
  compute_roots = FALSE,
  units = 'id',
  roots = coef(geefit),
  outer_args = list(model = geefit))
m_estimate(
  estFUN = example_ee,
  data = ohio,
  compute_roots = FALSE,
  units = 'id',
  roots = unlist(getME(glmmfit, c('beta', 'theta'))),
  outer_args = list(model = glmmfit))
 }
}
