% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_fn.R
\name{spectre.points}
\alias{spectre.points}
\title{Get SPECTRE data from points.}
\usage{
spectre.points(index, points)
}
\arguments{
\item{index}{numeric. A vector of integers specifying the layers. Refer to the documentation of 
\code{\link[gecko:spectre.citations]{gecko::spectre.citations()}} for a list
of available layers.}

\item{points}{data.frame or matrix. Containing point data coordinates, organized in longitude, latitude (longlat).}
}
\value{
data.frame or matrix. Contains both the points given as well as 
their respective values for each layer specified.
}
\description{
Downloads SPECTRE layer data according to a selection of points.
}
\examples{
\dontrun{
localities = gecko.data("records")
local_threats = spectre.points(c(2,3), localities)
}
}
