% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{has_spatialite}
\alias{has_spatialite}
\title{Is SpatiaLite available?}
\usage{
has_spatialite()
}
\value{
Logical scalar. \code{TRUE} if SpatiaLite is available to GDAL.
}
\description{
\code{has_spatialite()} returns a logical value indicating whether GDAL was
built with support for the SpatiaLite library. SpatiaLite extends the
SQLite core to support full Spatial SQL capabilities.
}
\details{
GDAL supports executing SQL statements against a datasource. For most file
formats (e.g. Shapefiles, GeoJSON, FlatGeobuf files), the built-in OGR SQL
dialect will be used by default. It is also possible to request the
alternate \code{"SQLite"}  dialect, which will use the SQLite engine to evaluate
commands on GDAL datasets. This assumes that GDAL is built with support for
SQLite, and preferably with Spatialite support too to benefit from spatial
functions.
}
\note{
All GDAL/OGR drivers for database systems, e.g., PostgreSQL / PostGIS,
Oracle Spatial, SQLite / Spatialite RDBMS, GeoPackage, etc., override the
\code{GDALDataset::ExecuteSQL()} function with a dedicated implementation and, by
default, pass the SQL statements directly to the underlying RDBMS. In these
cases the SQL syntax varies in some particulars from OGR SQL. Also, anything
possible in SQL can then be accomplished for these particular databases. For
those drivers, it is also possible to explicitly request the \code{OGRSQL} or
\code{SQLite} dialects, although performance will generally be much less than the
native SQL engine of those database systems.
}
\examples{
has_spatialite()
}
\seealso{
\code{\link[=ogrinfo]{ogrinfo()}}, \code{\link[=ogr_execute_sql]{ogr_execute_sql()}}

OGR SQL dialect and SQLITE SQL dialect:\cr
\url{https://gdal.org/en/stable/user/ogr_sql_sqlite_dialect.html}
}
