% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_rasterize.R
\name{gdal_rasterize}
\alias{gdal_rasterize}
\title{Interface to GDAL's gdal_rasterize utility}
\usage{
gdal_rasterize(
  src_datasource,
  dst_filename,
  ...,
  b,
  i,
  at,
  burn,
  a,
  threeD,
  l,
  where,
  sql,
  dialect,
  of,
  a_srs,
  co,
  a_nodata,
  init,
  te,
  tr,
  tap,
  ts,
  ot,
  q,
  dryrun = FALSE
)
}
\arguments{
\item{src_datasource}{Character. Path to a GDAL-supported readable
datasource.}

\item{dst_filename}{Character. Path to a GDAL-supported output
file.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{b, i, at, burn, a, threeD, l, where, sql, dialect, of}{See the GDAL
project's
\href{https://gdal.org/programs/gdal_rasterize.html}{gdal_rasterize
documentation} for details.}

\item{a_srs, co, a_nodata, init, te, tr, tap, ts, ot, q}{See the GDAL
project's
\href{https://gdal.org/programs/gdal_rasterize.html}{gdal_rasterize
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
None. Called instead for its side effect.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{gdal_rasterize}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/gdal_rasterize.html}.
}
\examples{
\donttest{
if(require(raster)) {
    ## Prepare file paths of example shapefile and template raster file
    vect_file <- system.file("external/lux.shp", package = "raster")
    td <- tempdir()
    rast_file <- file.path(td, "lux_rast.tif")

    ## Construct and save an appropriately sized 'empty' raster
    SPDF <- shapefile(vect_file)
    lonlatratio <- 1 / cospi(mean(coordinates(SPDF)[,2]) / 180)
    rr <- raster(extent(SPDF),
                 resolution = c(lonlatratio * 0.01, 0.01),
                 crs = crs(SPDF))
    ## Note: this next line warns that raster is empty
    writeRaster(rr, filename = rast_file, overwrite = TRUE)

    ## Rasterize polygon using empty raster and check that it worked
    gdal_rasterize(vect_file, rast_file, a = "ID_2")
    plot(raster(rast_file))
}
}
}
\author{
Joshua O'Brien
}
